clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
all_marks = {'o','+','*','.','x','s','d','^','v','>','<','p','h'};

%% DATI LASER
x0=[0 -10 -30 -50 -70];
s=[50 100 120 150];

s50_x0=[1.92 1.95 1.93]*1e5;
s50_x10=[1.94 1.93 1.94]*1e5;
s50_x30=[1.94 1.95 1.98]*1e5;
s50_x50=[1.96 1.97 1.97]*1e5;
s50_x70=[1.95 1.93 1.97]*1e5;
s50_medi=[mean(s50_x0) mean(s50_x10) mean(s50_x30) mean(s50_x50) mean(s50_x70)];

s100_x0=[2.57 2.58 2.49]*1e5;
s100_x10=[2.56 2.50 2.50]*1e5;
s100_x30=[2.46 2.40 2.39]*1e5;
s100_x50=[2.34 2.34 2.35]*1e5;
s100_medi=[mean(s100_x0) mean(s100_x10) mean(s100_x30) mean(s100_x50)];

s120_x0=[2.76 2.70 2.69]*1e5;
s120_x10=[2.73 2.73 2.73]*1e5;
s120_x30=[2.69 2.69 2.70]*1e5;
s120_x50=[2.67 2.67 2.66]*1e5;
s120_medi=[mean(s120_x0) mean(s120_x10) mean(s120_x30) mean(s120_x50)];

s150_x0=[5.04 4.99 5.12]*1e5;
s150_x10=[5.02 5.16 5.13]*1e5;
s150_x30=[5.03 5.12 5.00]*1e5;
s150_medi=[mean(s150_x0) mean(s150_x10) mean(s150_x30)];


figure 
plot(x0,s50_medi,'b-','linewidth',2),grid on, hold on,
plot(x0(1:4),s100_medi,'r-','linewidth',2),grid on, hold on,
plot(x0(1:4),s120_medi,'g-','linewidth',2),grid on, hold on,
plot(x0(1:3),s150_medi,'k-','linewidth',2),grid on, hold on,
xlabel('Precarico $\: (\mu m)$'),
ylabel('Rigidezza membrana $\: (N/m)$'),
legend('Spessore membrana = 50\mum','Spessore membrana = 100\mum','Spessore membrana = 120\mum','Spessore membrana = 150\mum')
title('Confronto rigidezze membranali calcolate tramite banco con sensore laser')

%% DATI CAPACITIVO
x_0=[0 -10 -20 -30 -40 -50 -60 -70];

s50_x50_p3=[1.71 1.73 1.73]*1e5;
s50_x60_p3=[1.70 1.70 1.69]*1e5;
s50_x70_p3=[1.66 1.68 1.67]*1e5;
s50_medi_p3=[mean(s50_x50_p3) mean(s50_x60_p3) mean(s50_x70_p3)];

s100_x50_p3=[2.35 2.45 2.43]*1e5;
s100_x60_p3=[2.38 2.39 2.40]*1e5;
s100_x70_p3=[3.27 3.24 3.21]*1e5;
s100_medi_p3=[mean(s100_x50_p3) mean(s100_x60_p3) mean(s100_x70_p3)];

s120_x30_p3=[2.88 2.90 2.85]*1e5;
s120_x40_p3=[2.86 2.83 2.80]*1e5;
s120_x50_p3=[2.74 2.75 2.84]*1e5;
s120_medi_p3=[mean(s120_x30_p3) mean(s120_x40_p3) mean(s120_x50_p3)];

s150_x30_p3=[3.88 3.88 3.95]*1e5;
s150_x40_p3=[3.86 3.93 3.81]*1e5;
s150_x50_p3=[3.72 3.75 3.79]*1e5;
s150_medi_p3=[mean(s150_x30_p3) mean(s150_x40_p3) mean(s150_x50_p3)];

figure 
plot(x_0(6:8),s50_medi_p3,'b-','linewidth',2),grid on, hold on,
plot(x_0(6:8),s100_medi_p3,'r-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s120_medi_p3,'g-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s150_medi_p3,'k-','linewidth',2),grid on, hold on,
xlabel('Precarico $\: (\mu m)$'),
ylabel('Rigidezza membrana $\: (N/m)$'),
legend('Spessore membrana = 50\mum','Spessore membrana = 100\mum','Spessore membrana = 120\mum','Spessore membrana = 150\mum')
% title('Confronto rigidezze membranali calcolate tramite banco con sensore capacitivo a $P_{s}$ = 3bar')
title('Rigidezze membranali')



s50_x50_p4=[1.94 1.95 1.94]*1e5;
s50_x60_p4=[1.93 1.93 1.93]*1e5;
s50_x70_p4=[1.85 1.88 1.86]*1e5;
s50_medi_p4=[mean(s50_x50_p4) mean(s50_x60_p4) mean(s50_x70_p4)];

s100_x50_p4=[2.59 2.59 2.58]*1e5;
s100_x60_p4=[2.60 2.60 2.60]*1e5;
s100_x70_p4=[2.94 2.92 2.96]*1e5;
s100_medi_p4=[mean(s100_x50_p4) mean(s100_x60_p4) mean(s100_x70_p4)];

s120_x30_p4=[3.06 3.08 3.07]*1e5;
s120_x40_p4=[3.01 3.03 3.05]*1e5;
s120_x50_p4=[2.99 2.99 3.00]*1e5;
s120_medi_p4=[mean(s120_x30_p4) mean(s120_x40_p4) mean(s120_x50_p4)];

s150_x30_p4=[4.42 4.49 4.48]*1e5;
s150_x40_p4=[4.35 4.37 4.41]*1e5;
s150_x50_p4=[4.26 4.31 4.33]*1e5;
s150_medi_p4=[mean(s150_x30_p4) mean(s150_x40_p4) mean(s150_x50_p4)];

figure 
plot(x_0(6:8),s50_medi_p4,'b-','linewidth',2),grid on, hold on,
plot(x_0(6:8),s100_medi_p4,'r-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s120_medi_p4,'g-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s150_medi_p4,'k-','linewidth',2),grid on, hold on,
xlabel('Precarico $\: (\mu m)$'),
ylabel('Rigidezza membrana $\: (N/m)$'),
legend('Spessore membrana = 50\mum','Spessore membrana = 100\mum','Spessore membrana = 120\mum','Spessore membrana = 150\mum')
title('Confronto rigidezze membranali calcolate tramite banco con sensore capacitivo a $P_{s}$ = 4bar')

figure 
plot(x_0(6:8),s50_medi_p4,'b--','linewidth',2),grid on, hold on,
plot(x0,s50_medi,'b-','linewidth',2),grid on, hold on,
plot(x_0(6:8),s100_medi_p4,'r--','linewidth',2),grid on, hold on,
plot(x0(1:4),s100_medi,'r-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s120_medi_p4,'g--','linewidth',2),grid on, hold on,
plot(x0(1:4),s120_medi,'g-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s150_medi_p4,'k--','linewidth',2),grid on, hold on,
plot(x0(1:3),s150_medi,'k-','linewidth',2),grid on, hold on,
xlabel('Precarico $\: (\mu m)$'),
ylabel('Rigidezza membrana $\: (N/m)$'),
legend('Sensore capacitivo, s = 50\mum','Sensore laser, s = 50\mum','Sensore capacitivo, s = 100\mum','Sensore laser, s = 100\mum','Sensore capacitivo, s = 120\mum','Sensore laser, s = 120\mum','Sensore capacitivo, s = 150\mum','Sensore laser, s = 150\mum')
title('Confronto rigidezze membranali')
% title('Confronto rigidezze membranali calcolate a vari valori di precarico a $P_{s}$ = 4bar')

s50_x0_p5=[3.10 3.23 3.11]*1e5;
s50_x10_p5=[3.10 3.12 3.10]*1e5;
s50_x20_p5=[3.11 3.11 3.08]*1e5;
s50_x30_p5=[2.26 2.23 2.23]*1e5;
s50_x40_p5=[2.23 2.21 2.22]*1e5;
s50_x50_p5=[2.20 2.20 2.19]*1e5;
s50_x60_p5=[2.16 2.16 2.17]*1e5;
s50_x70_p5=[2.10 2.10 2.11]*1e5;
s50_medi_p5=[mean(s50_x0_p5) mean(s50_x10_p5) mean(s50_x20_p5) mean(s50_x30_p5) mean(s50_x40_p5) mean(s50_x50_p5) mean(s50_x60_p5) mean(s50_x70_p5)];

s100_x0_p5=[4.12 4.29 4.28]*1e5;
s100_x10_p5=[4.33 4.35 4.37]*1e5;
s100_x20_p5=[4.29 4.30 4.31]*1e5;
s100_x30_p5=[4.27 4.23 4.22]*1e5;
s100_x40_p5=[4.15 4.10 4.13]*1e5;
s100_x50_p5=[2.77 2.77 2.77]*1e5;
s100_x60_p5=[2.76 2.77 2.76]*1e5;
s100_x70_p5=[2.94 2.95 2.94]*1e5;
s100_medi_p5=[mean(s100_x0_p5) mean(s100_x10_p5) mean(s100_x20_p5) mean(s100_x30_p5) mean(s100_x40_p5) mean(s100_x50_p5) mean(s100_x60_p5) mean(s100_x70_p5)];

s120_x0_p5=[3.59 3.54 3.53]*1e5;
s120_x10_p5=[3.48 3.44 3.44]*1e5;
s120_x20_p5=[3.36 3.33 3.37]*1e5;
s120_x30_p5=[3.27 3.29 3.29]*1e5;
s120_x40_p5=[3.23 3.22 3.23]*1e5;
s120_x50_p5=[3.16 3.21 3.22]*1e5;
s120_medi_p5=[mean(s120_x0_p5) mean(s120_x10_p5) mean(s120_x20_p5) mean(s120_x30_p5) mean(s120_x40_p5) mean(s120_x50_p5)];

s150_x0_p5=[5.29 5.27 5.28]*1e5;
s150_x10_p5=[5.17 5.15 5.13]*1e5;
s150_x20_p5=[5.03 5.06 5.05]*1e5;
s150_x30_p5=[4.89 4.89 4.91]*1e5;
s150_x40_p5=[4.79 4.79 4.77]*1e5;
s150_x50_p5=[4.70 4.73 4.70]*1e5;
s150_medi_p5=[mean(s150_x0_p5) mean(s150_x10_p5) mean(s150_x20_p5) mean(s150_x30_p5) mean(s150_x40_p5) mean(s150_x50_p5)];

figure 
plot(x_0,s50_medi_p5,'b-','linewidth',2),grid on, hold on,
plot(x_0,s100_medi_p5,'r-','linewidth',2),grid on, hold on,
plot(x_0(1:6),s120_medi_p5,'g-','linewidth',2),grid on, hold on,
plot(x_0(1:6),s150_medi_p5,'k-','linewidth',2),grid on, hold on,
xlabel('Precarico $\: (\mu m)$'),
ylabel('Rigidezza membrana $\: (N/m)$'),
legend('Spessore membrana = 50\mum','Spessore membrana = 100\mum','Spessore membrana = 120\mum','Spessore membrana = 150\mum')
title('Rigidezze membranali')
% title('Confronto rigidezze membranali calcolate tramite banco con sensore capacitivo a $P_{s}$ = 5bar')


s50_x50_p4_mod=[1.40]*1e5;
s50_x60_p4_mod=[1.60]*1e5;
s50_x70_p4_mod=[1.60]*1e5;
s50_medi_p4_mod=[mean(s50_x50_p4_mod) mean(s50_x60_p4_mod) mean(s50_x70_p4_mod)];

s100_x50_p4_mod=[2.65]*1e5;
s100_x60_p4_mod=[2.66]*1e5;
s100_x70_p4_mod=[2.65]*1e5;
s100_medi_p4_mod=[mean(s100_x50_p4_mod) mean(s100_x60_p4_mod) mean(s100_x70_p4_mod)];

s120_x30_p4_mod=[3.20]*1e5;
s120_x40_p4_mod=[3.20]*1e5;
s120_x50_p4_mod=[3.20]*1e5;
s120_medi_p4_mod=[mean(s120_x30_p4_mod) mean(s120_x40_p4_mod) mean(s120_x50_p4_mod)];

s150_x30_p4_mod=[2.50]*1e5;
s150_x40_p4_mod=[3.30]*1e5;
s150_x50_p4_mod=[3.50]*1e5;
s150_medi_p4_mod=[mean(s150_x30_p4_mod) mean(s150_x40_p4_mod) mean(s150_x50_p4_mod)];

figure 
plot(x_0(6:8),s50_medi_p4,'b--','linewidth',2),grid on, hold on,
plot(x_0(6:8),s50_medi_p4_mod,'bo-','linewidth',2),grid on, hold on,
plot(x0,s50_medi,'b-','linewidth',2),grid on, hold on,
plot(x_0(6:8),s100_medi_p4,'r--','linewidth',2),grid on, hold on,
plot(x_0(6:8),s100_medi_p4_mod,'ro-','linewidth',2),grid on, hold on,
plot(x0(1:4),s100_medi,'r-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s120_medi_p4,'g--','linewidth',2),grid on, hold on,
plot(x_0(4:6),s120_medi_p4_mod,'go-','linewidth',2),grid on, hold on,
plot(x0(1:4),s120_medi,'g-','linewidth',2),grid on, hold on,
plot(x_0(4:6),s150_medi_p4,'k--','linewidth',2),grid on, hold on,
plot(x_0(4:6),s150_medi_p4_mod,'ko-','linewidth',2),grid on, hold on,
plot(x0(1:3),s150_medi,'k-','linewidth',2),grid on, hold on,
xlabel('Precarico $\: (\mu m)$'),
ylabel('Rigidezza membrana $\: (N/m)$'),
legend('Exp (capacitivo), s = 50\mum','Mod, s = 50\mum','Exp (laser), s = 50\mum','Exp (capacitivo), s = 100\mum','Mod, s = 100\mum','Exp (laser), s = 100\mum','Exp (capacitivo), s = 120\mum','Mod, s = 120\mum','Exp (laser), s = 120\mum','Exp (capacitivo), s = 150\mum','Mod, s = 150\mum','Exp (laser), s = 150\mum')
title('Confronto rigidezze membranali numeriche e sperimentali a $P_{s}$ = 4bar')


%% CALCOLO SPESSORE REALE PER DIVERSI VALORI DI PROGETTO A Ps=4bar
d_foro=8*1e-3;
r=d_foro/2;
E=201e9;
nu=0.3;

k_num_s50_p4=mean(s50_medi_p4_mod(2:end));
k_num_s100_p4=mean(s100_medi_p4_mod);
k_num_s120_p4=mean(s120_medi_p4_mod);
k_num_s150_p4=mean(s150_medi_p4_mod(2:end));
k_num_p4=[k_num_s50_p4 k_num_s100_p4 k_num_s120_p4 k_num_s150_p4];

k_exp_s50=mean(s50_medi_p4);
k_exp_s100=mean(s100_medi_p4);
k_exp_s120=mean(s120_medi_p4);
k_exp_s150=mean(s150_medi_p4);
k_exp=[k_exp_s50 k_exp_s100 k_exp_s120 k_exp_s150];

s_vero=[50 100 120 150];

figure 
plot(k_num_p4,s_vero,'ko-','linewidth',2),grid on, hold on,
xlabel('Rigidezza modello $\: (N/m)$'),
ylabel('Spessore vero $\: (\mu m)$'),
title('Curva di confronto tra rigidezza numerica e spessore vero a $P_{s}$ = 4bar ')


k_m_p4=1.6561*1e5;

if (k_m_p4>k_num_s150_p4)
    Spessore_p4=['Spessore maggiore di 150 micron']
elseif (k_m_p4<=k_num_s150_p4 & k_m_p4>k_num_s120_p4)
        Spessore_p4=s_vero(4)-(s_vero(4)-s_vero(3))/(k_num_s150_p4-k_num_s120_p4)*(k_num_s150_p4-k_m_p4)
elseif (k_m_p4<=k_num_s120_p4 & k_m_p4>k_num_s100_p4)
        Spessore_p4=s_vero(3)-(s_vero(3)-s_vero(2))/(k_num_s120_p4-k_num_s100_p4)*(k_num_s120_p4-k_m_p4)
elseif (k_m_p4<=k_num_s100_p4 & k_m_p4>k_num_s50_p4)
        Spessore_p4=s_vero(2)-(s_vero(2)-s_vero(1))/(k_num_s100_p4-k_num_s50_p4)*(k_num_s100_p4-k_m_p4)
elseif (k_m_p4<k_num_s50_p4)
        Spessore_p4=['Spessore minore di 50 micron']
end

%% CALCOLO SPESSORE REALE PER DIVERSI VALORI DI PROGETTO A Ps=3bar

s50_x50_p3_mod=[1.40]*1e5;
s50_x60_p3_mod=[1.40]*1e5;
s50_x70_p3_mod=[1.40]*1e5;
s50_medi_p3_mod=[mean(s50_x50_p3_mod) mean(s50_x60_p3_mod) mean(s50_x70_p3_mod)];

s100_x50_p3_mod=[2.50]*1e5;
s100_x60_p3_mod=[2.50]*1e5;
s100_x70_p3_mod=[2.50]*1e5;
s100_medi_p3_mod=[mean(s100_x50_p3_mod) mean(s100_x60_p3_mod) mean(s100_x70_p3_mod)];

s120_x30_p3_mod=[2.00]*1e5;
s120_x40_p3_mod=[2.80]*1e5;
s120_x50_p3_mod=[2.80]*1e5;
s120_medi_p3_mod=[mean(s120_x30_p3_mod) mean(s120_x40_p3_mod) mean(s120_x50_p3_mod)];

s150_x30_p3_mod=[2.50]*1e5;
s150_x40_p3_mod=[3.30]*1e5;
s150_x50_p3_mod=[3.30]*1e5;
s150_medi_p3_mod=[mean(s150_x30_p3_mod) mean(s150_x40_p3_mod) mean(s150_x50_p3_mod)];

k_num_s50_p3=mean(s50_medi_p3_mod);
k_num_s100_p3=mean(s100_medi_p3_mod);
k_num_s120_p3=mean(s120_medi_p3_mod(2:end));
k_num_s150_p3=mean(s150_medi_p3_mod(2:end));
k_num_p3=[k_num_s50_p3 k_num_s100_p3 k_num_s120_p3 k_num_s150_p3];

figure 
plot(k_num_p3,s_vero,'ko-','linewidth',2),grid on, hold on,
xlabel('Rigidezza modello $\: (N/m)$'),
ylabel('Spessore vero $\: (\mu m)$'),
title('Curva di confronto tra rigidezza numerica e spessore vero a $P_{s}$ = 3bar ')

k_m_p3=1.4158*1e5;

if (k_m_p3>k_num_s150_p3)
    Spessore_p3=['Spessore maggiore di 150 micron']
elseif (k_m_p3<=k_num_s150_p3 & k_m_p3>k_num_s120_p3)
        Spessore_p3=s_vero(4)-(s_vero(4)-s_vero(3))/(k_num_s150_p3-k_num_s120_p3)*(k_num_s150_p3-k_m_p3)
elseif (k_m_p3<=k_num_s120_p3 & k_m_p3>k_num_s100_p3)
        Spessore_p3=s_vero(3)-(s_vero(3)-s_vero(2))/(k_num_s120_p3-k_num_s100_p3)*(k_num_s120_p3-k_m_p3)
elseif (k_m_p3<=k_num_s100_p3 & k_m_p3>k_num_s50_p3)
        Spessore_p3=s_vero(2)-(s_vero(2)-s_vero(1))/(k_num_s100_p3-k_num_s50_p3)*(k_num_s100_p3-k_m_p3)
elseif (k_m_p3<k_num_s50_p3)
        Spessore_p3=['Spessore minore di 50 micron']
end

%% CALCOLO SPESSORE REALE PER DIVERSI VALORI DI PROGETTO A Ps=5bar

s50_x50_p5_mod=[1.95]*1e5;
s50_x60_p5_mod=[1.65]*1e5;
s50_x70_p5_mod=[1.75]*1e5;
s50_medi_p5_mod=[mean(s50_x50_p5_mod) mean(s50_x60_p5_mod) mean(s50_x70_p5_mod)];

s100_x50_p5_mod=[3.05]*1e5;
s100_x60_p5_mod=[3.00]*1e5;
s100_x70_p5_mod=[3.10]*1e5;
s100_medi_p5_mod=[mean(s100_x50_p5_mod) mean(s100_x60_p5_mod) mean(s100_x70_p5_mod)];

s120_x30_p5_mod=[3.50]*1e5;
s120_x40_p5_mod=[3.20]*1e5;
s120_x50_p5_mod=[3.50]*1e5;
s120_medi_p5_mod=[mean(s120_x30_p5_mod) mean(s120_x40_p5_mod) mean(s120_x50_p5_mod)];

s150_x30_p5_mod=[3.00]*1e5;
s150_x40_p5_mod=[3.20]*1e5;
s150_x50_p5_mod=[3.60]*1e5;
s150_medi_p5_mod=[mean(s150_x30_p5_mod) mean(s150_x40_p5_mod) mean(s150_x50_p5_mod)];

k_num_s50_p5=mean(s50_medi_p5_mod);
k_num_s100_p5=mean(s100_medi_p5_mod);
k_num_s120_p5=mean(s120_medi_p5_mod);
k_num_s150_p5=mean(s150_medi_p5_mod(end));
k_num_p5=[k_num_s50_p5 k_num_s100_p5 k_num_s120_p5 k_num_s150_p5];

figure 
plot(k_num_p3,s_vero,'bo-','linewidth',2),grid on, hold on,
plot(k_num_p4,s_vero,'ro-','linewidth',2),grid on, hold on,
plot(k_num_p5,s_vero,'ko-','linewidth',2),grid on, hold on,
xlabel('Rigidezza numerica $\: (N/m)$'),
ylabel('Spessore membrana $\: (\mu m)$'),
title('Curva di confronto tra rigidezza numerica e spessore spessore membranale')
legend('P_{s} = 3bar', 'P_{s} = 4bar', 'P_{s} = 5bar')

k_m_p5=1.8023*1e5;

if (k_m_p5>k_num_s150_p5)
    Spessore_p5=['Spessore maggiore di 150 micron']
elseif (k_m_p5<=k_num_s150_p5 & k_m_p5>k_num_s120_p5)
        Spessore_p5=s_vero(4)-(s_vero(4)-s_vero(3))/(k_num_s150_p5-k_num_s120_p5)*(k_num_s150_p5-k_m_p5)
elseif (k_m_p5<=k_num_s120_p5 & k_m_p5>k_num_s100_p5)
        Spessore_p5=s_vero(3)-(s_vero(3)-s_vero(2))/(k_num_s120_p5-k_num_s100_p5)*(k_num_s120_p5-k_m_p5)
elseif (k_m_p5<=k_num_s100_p5 & k_m_p5>k_num_s50_p5)
        Spessore_p5=s_vero(2)-(s_vero(2)-s_vero(1))/(k_num_s100_p5-k_num_s50_p5)*(k_num_s100_p5-k_m_p5)
elseif (k_m_p5<k_num_s50_p5)
        Spessore_p5=['Spessore minore di 50 micron']
end

